//MSA Converter
//Version 2.1
//
// Corrections de Bugs:
// - CONVERSION : Correction de la conversion ST->MSA qui ne marchait plus
// - TOUT : Correction dtection nombre de pistes dans fichier *.ST (endtrack-1)
//
// Ajouts:
// - CONVERSION & CONFIG : Choix de la mise en forme des noms de fichiers lors des conversions et compressions ZIP
//
// Modifications:
// - CHILDWIN : Pr-contrle de la taille des fichiers avant transfert explorateur->image disque
//   pour viter de charger des gros fichiers pour rien
// - Mise  jour du composant Zipforge  la version 2.55 -> programme plus petit
//

unit MAIN;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, ZipForge, ShellApi,
  CHILDWIN, about, tout, Crc32, traduction, explorateur;

type
  TMSA_Converter = class(TForm)
    Menu_general: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    ActionList1: TActionList;
    FileNew1: TAction;
    FileExit1: TAction;
    FileOpen1: TAction;
    WindowCascade1: TWindowCascade;
    WindowTileHorizontal1: TWindowTileHorizontal;
    WindowArrangeAll1: TWindowArrange;
    WindowMinimizeAll1: TWindowMinimizeAll;
    HelpAbout1: TAction;
    WindowTileVertical1: TWindowTileVertical;
    WindowTileItem2: TMenuItem;
    Barre_d_outils: TToolBar;
    Bouton_ouvrir: TToolButton;
    Bouton_nouvelle_disquette: TToolButton;
    Separateur_1: TToolButton;
    Bouton_cascade: TToolButton;
    Bouton_mosaique_horizontale: TToolButton;
    Bouton_mosaique_verticale: TToolButton;
    Icones: TImageList;
    zip: TZipForge;
    selecfichier: TOpenDialog;
    Separateur_2: TToolButton;
    Bouton_options: TToolButton;
    Separateur_4: TToolButton;
    Bouton_controle_disquette: TToolButton;
    Bouton_batch_zip: TToolButton;
    Bouton_doublons: TToolButton;
    Act_controle_image_disque: TAction;
    Act_batch_zip: TAction;
    Act_recherche_doublons: TAction;
    Barre_d_etat: TStatusBar;
    ListBox1: TListBox;
    Bouton_conversion: TToolButton;
    Act_conversion: TAction;
    Conversionimagedisque1: TMenuItem;
    Conversionimagedisque2: TMenuItem;
    Controleimagedisque1: TMenuItem;
    Batchzip1: TMenuItem;
    Recherchedoublons1: TMenuItem;
    Act_options: TAction;
    N2: TMenuItem;
    Options1: TMenuItem;
    FileClose1: TAction;
    Bouton_fermer: TToolButton;
    FileSave1: TAction;
    Sauvegarder1: TMenuItem;
    Bouton_sauvegarder: TToolButton;
    Act_explorateur: TAction;
    Explorateur: TMenuItem;
    Separateur_3: TToolButton;
    Bouton_explorateur: TToolButton;
    N3: TMenuItem;
    Bouton_nouveau_repertoire: TToolButton;
    Separateur_5: TToolButton;
    Bouton_supprimer_fichier: TToolButton;
    Newdir1: TAction;
    Filedelete1: TAction;
    liste_transfert: TListView;
    procedure FileOpen1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Act_controle_image_disqueExecute(Sender: TObject);
    procedure Act_batch_zipExecute(Sender: TObject);
    procedure Act_recherche_doublonsExecute(Sender: TObject);
    procedure FileNew1Execute(Sender: TObject);
    procedure Act_optionsExecute(Sender: TObject);
    procedure Act_conversionExecute(Sender: TObject);
    procedure FileClose1Execute(Sender: TObject);
    procedure Act_explorateurExecute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure Newdir1Execute(Sender: TObject);
    procedure Filedelete1Execute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Dclarations prives }

  public
    { Dclarations publiques }
  end;

var
    MSA_Converter: TMSA_Converter;
    fichier_temp:imagedisk;
    fenetre_explorateur:texplorer;
    premiere_activation:boolean;

implementation

uses config, disque_vierge, conversion, scan_disk;


{$R *.dfm}

//Ouvre une image disque existante
procedure TMSA_Converter.FileOpen1Execute(Sender: TObject);
var
    nouv_mdi:tmdichild;
    compteur:integer;
    deja_ouvert:boolean;

begin
    MSA_Converter.selecfichier.title:=textes_general[75];
    MSA_Converter.selecfichier.filter:=textes_general[70]+'|'+textes_general[71]+'|'+textes_general[72]+'|'+textes_general[73]+'|'+textes_general[74]+'|'+textes_general[80];
    MSA_Converter.selecfichier.fileName:='';
    MSA_Converter.selecfichier.options:=[ofFileMustExist,ofPathMustExist,ofHideReadOnly];
    MSA_Converter.selecfichier.InitialDir:=rep_utilisateur;

    if MSA_Converter.selecfichier.Execute=true then
    begin
        //Contrle si l'image disque n'est pas dj ouverte
        deja_ouvert:=false;
        for compteur:=MSA_Converter.MDIChildCount-1 downto 0 do
        begin
            if MSA_Converter.mdichildren[compteur] is tmdichild then
            begin
                nouv_mdi:=MSA_Converter.mdichildren[compteur] as tmdichild;
                if nouv_mdi.Caption=MSA_Converter.selecfichier.filename then
                begin
                    deja_ouvert:=true;
                    nouv_mdi.Show;
                end;
            end;
        end;

        //Si non, on l'ouvre
        if deja_ouvert=false then
        begin
            rep_utilisateur:=extraire_repertoire(MSA_Converter.selecfichier.filename);
            nouv_mdi:=TMDIChild.Create(Application);
            if nouv_mdi.disquette.fichier_ok=false then nouv_mdi.Close;
        end
        else MessageDlg(MSA_Converter.selecfichier.filename+textes_general[100], mtInformation, [mbOk], 0);
    end;
end;

//Ouvre la fentre 'A Propos'
procedure TMSA_Converter.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

//Ferme l'application
procedure TMSA_Converter.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

//Initialisation des donnes  l'ouverture de l'application
procedure TMSA_Converter.FormCreate(Sender: TObject);
begin
    premiere_activation:=true;
    //Mise en forme de la date et de l'heure pour tous les pays
    shortdateformat:='dd/mm/yyyy';
    longtimeformat:='hh:nn:ss';
    DateSeparator:='/';
    TimeSeparator:=':';
    //Lecture du rpertoire de l'excutable de MSA Converter
    rep_app:=ExtractFilePath(Application.Exename);
    lire_fichier_config;
    traduction_textes_general;
end;

//Quitte l'application
procedure TMSA_Converter.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
    compteur:integer;
    booltemp:boolean;

begin
    setlength(fichier_temp.donnees,0);
    //Ferme toutes les fentres
    ecrit_ini_main;

    if fenetre_explorateur=nil then booltemp:=false else booltemp:=true;
    fichierini.WriteBool('main', 'explorateur_ouvert', booltemp);

    for compteur:= MDIChildCount-1 downto 0 do MDIChildren[compteur].Close;
    fichierini.UpdateFile;
    fichierini.Free;
end;

//Contrle de l'tat des clusters dans une image disque
procedure TMSA_Converter.Act_controle_image_disqueExecute(Sender: TObject);
begin
    scandisk.show;
end;

//Batch compression
//(compression de fichiers multiples un par un (Un fichier par archive ZIP))
procedure TMSA_Converter.Act_batch_zipExecute(Sender: TObject);
var
    nomfichier:string;
    nom_fichier_zip:string;
    nombre_fichiers:integer;
    num_fichier:integer;

begin
    listbox1.items.Clear;
    selecfichier.title:=textes_general[77];
    selecfichier.filter:=textes_general[79];
    selecfichier.fileName:='';
    selecfichier.options:=[ofFileMustExist,ofPathMustExist,ofAllowMultiSelect,ofHideReadOnly];
    selecfichier.InitialDir:=rep_utilisateur;

    if selecfichier.Execute=true then
    begin
        listbox1.items.Assign(selecfichier.files);
        rep_utilisateur:=extraire_repertoire(selecfichier.files[0]);
        nombre_fichiers:=listbox1.Items.Count;
        if nombre_fichiers>0 then
            if MessageDlg(textes_general[101]+inttostr(nombre_fichiers)+textes_general[102]
               ,mtConfirmation, [mbYes, mbNo], 0) = mrYes then
            begin
                for num_fichier:=0 to nombre_fichiers-1 do
                begin
                    nomfichier:=listbox1.Items[num_fichier];
                    nom_fichier_zip:=nom_zip(nomfichier);

                    if fileexists(nom_fichier_zip) then deletefile(nom_fichier_zip);

                    with msa_converter.zip do
                    begin
                        filename :=nom_fichier_zip;
                        openarchive(fmCreate);
                        addfiles(nomfichier);
                        closearchive;
                    end;
                    barre_d_etat.SimpleText:=textes_general[103]+inttostr(num_fichier+1)+' / '+inttostr(nombre_fichiers);
                end;
            end;
        listbox1.items.Clear;
        barre_d_etat.SimpleText:=textes_general[104];
    end;
end;

//Contrle de fichiers doublons
//(recherche de fichiers en double par rapport  la taille et au CRC32)
procedure TMSA_Converter.Act_recherche_doublonsExecute(Sender: TObject);
var
    crcvalue:longword;
    error:word;
    fichier_compare:integer;
    nombre_fichiers:integer;
    num_fichier:integer;
    num_fichier_total:integer;
    crctab:array of longword;
    tailletab:array of integer;
    nomfichier:array of string;
    fichier_sour:file of byte;
    type_fichier:string;
    fichier_archive:TZFArchiveItem;
    premier_doublon:boolean;
    premier_fichier_dans_zip:boolean;
    choix_zip:integer;
    choix_plusieurs_rep:integer;
    result_selecfichier:boolean;

    taille:integer;
    rapport:textfile;

begin
    listbox1.items.Clear;
    num_fichier_total:=0;
    choix_zip:=MessageDlg(textes_general[124],mtConfirmation, [mbYes, mbNo], 0);
    repeat
        choix_plusieurs_rep:=mrNo;
        selecfichier.title:=textes_general[78];
        selecfichier.filter:=textes_general[79];
        selecfichier.fileName:='';
        selecfichier.options:=[ofFileMustExist,ofPathMustExist,ofAllowMultiSelect,ofHideReadOnly];
        selecfichier.InitialDir:=rep_utilisateur;
        result_selecfichier:=selecfichier.Execute;
        if result_selecfichier=true then
        begin
            rep_utilisateur:=extraire_repertoire(selecfichier.files[0]);
            listbox1.Items.Assign(selecfichier.files);
            nombre_fichiers:=listbox1.Count;
            if nombre_fichiers>0 then
            begin
                setlength(crctab,length(crctab)+nombre_fichiers);
                setlength(tailletab,length(tailletab)+nombre_fichiers);
                setlength(nomfichier,length(nomfichier)+nombre_fichiers);
                filemode:=0;    //Accs au fichier en lecture seule

                //Calcul des CRC32 et lecture taille des fichiers
                for num_fichier:=0 to nombre_fichiers-1 do
                begin
                    nomfichier[num_fichier_total]:=listbox1.Items[num_fichier];
                    barre_d_etat.SimpleText:=textes_general[105]+nomfichier[num_fichier_total];
                    type_fichier:=uppercase(extraire_type_fichier(nomfichier[num_fichier_total]));
                    if (type_fichier='ZIP') and (choix_zip=mrYes) then
                        with msa_converter.zip do
                        begin
                            filename :=nomfichier[num_fichier_total];
                            openarchive(fmOpenRead);
                            premier_fichier_dans_zip:=true;
                            if (FindFirst('*.*',fichier_archive,faAnyFile-faDirectory)) then
                            repeat
                                if premier_fichier_dans_zip=false then
                                begin
                                    setlength(crctab,length(crctab)+1);
                                    setlength(tailletab,length(tailletab)+1);
                                    setlength(nomfichier,length(nomfichier)+1);
                                end
                                else premier_fichier_dans_zip:=false;
                                nomfichier[num_fichier_total]:=filename+' - '+fichier_archive.FileName;
                                tailletab[num_fichier_total]:=fichier_archive.UncompressedSize;
                                crctab[num_fichier_total]:=fichier_archive.CRC;
                                inc(num_fichier_total);
                            until (not FindNext(fichier_archive));
                            closearchive;
                        end
                    else begin
                        CalcFileCRC32(nomfichier[num_fichier_total],crcvalue,error);
                        crctab[num_fichier_total]:=crcvalue;
                        assignfile(fichier_sour,nomfichier[num_fichier_total]);
                        reset(fichier_sour);
                        tailletab[num_fichier_total]:=filesize(fichier_sour);;
                        closefile(fichier_sour);
                        inc(num_fichier_total);
                    end;
                end;
            end;
            choix_plusieurs_rep:=MessageDlg(textes_general[125],mtConfirmation, [mbYes, mbNo], 0);
        end;
    until (result_selecfichier=false) or ((result_selecfichier=true) and (choix_plusieurs_rep=mrNo));

    listbox1.items.Clear;

    if result_selecfichier=true then
    begin
        if num_fichier_total>0 then
        begin
        //Compare les CRC32 et les tailles des fichiers et crit le rapport
            assignfile(rapport,rep_travail+'rapport.txt');
            rewrite(rapport);

            barre_d_etat.SimpleText:=textes_general[106];
            for num_fichier:=0 to num_fichier_total-1 do
            begin
                crcvalue:=crctab[num_fichier];
                taille:=tailletab[num_fichier];
                premier_doublon:=false;

                for fichier_compare:=0 to num_fichier_total-1 do
                    if fichier_compare<>num_fichier then
                        if (crctab[fichier_compare]=crcvalue) and (tailletab[fichier_compare]=taille) then
                        begin
                            if premier_doublon=false then
                            begin
                                writeln(rapport);
                                writeln(rapport,textes_general[120]+nomfichier[num_fichier]);
                                premier_doublon:=true;
                            end;
                            writeln(rapport,textes_general[121]+nomfichier[fichier_compare]);
                        end;
            end;

            closefile(rapport);

            ShellExecute(0, nil, 'notepad.exe', pchar(rep_travail+'rapport.txt'), nil, sw_normal);
        end;
        barre_d_etat.SimpleText:=textes_general[107];
    end;
    setlength(crctab,0);
    setlength(tailletab,0);
    setlength(nomfichier,0);
end;

//Ouvre la fentre de cration d'image disque vierge
procedure TMSA_Converter.FileNew1Execute(Sender: TObject);
begin
    disquette_vierge.show;
end;

//Ouvre la fentre des options
procedure TMSA_Converter.Act_optionsExecute(Sender: TObject);
begin
    Options.Show;
end;

//Ouvre la fentre de conversion
procedure TMSA_Converter.Act_conversionExecute(Sender: TObject);
begin
    barre_d_etat.SimpleText:=textes_general[108];
    convert.show;
end;

//Ferme la fentre active
procedure TMSA_Converter.FileClose1Execute(Sender: TObject);
begin
    if MSA_Converter.ActiveMDIChild<>nil then MSA_Converter.ActiveMDIChild.Close;
end;

//Ouvre la fentre de l'explorateur de fichiers
procedure TMSA_Converter.Act_explorateurExecute(Sender: TObject);
begin
    if fenetre_explorateur=nil then fenetre_explorateur:=TExplorer.Create(Application)
        else MessageDlg(textes_general[109], mtInformation, [mbOk], 0);
end;


//Sauvegarde l'image disque en cours d'dition
procedure TMSA_Converter.FileSave1Execute(Sender: TObject);
var
    fenetre:tmdichild;

begin
    if MSA_Converter.ActiveMDIChild<>nil then
        if  MSA_Converter.ActiveMDIChild is tmdichild then
        begin
            fenetre:=MSA_Converter.ActiveMDIChild as tmdichild;
            fenetre.sauvegarde_modifications;
        end;
end;


//Cre un nouveau rpertoire
procedure TMSA_Converter.Newdir1Execute(Sender: TObject);
var
    fenetre:tmdichild;

begin
    if msa_converter.ActiveMDIChild<>nil then
        if msa_converter.ActiveMDIChild is tmdichild then
        begin
            fenetre:=msa_converter.ActiveMDIChild as tmdichild;
            fenetre.nouveau_repertoire;
        end;
end;

//Effacement de fichier(s) ou de rpertoire
procedure TMSA_Converter.Filedelete1Execute(Sender: TObject);
var
    fenetre:tmdichild;

begin
    if msa_converter.ActiveMDIChild<>nil then
        if msa_converter.ActiveMDIChild is tmdichild then
        begin
            fenetre:=msa_converter.ActiveMDIChild as tmdichild;
            if fenetre.dossiers.Focused=true then fenetre.effacer_repertoire;
            if fenetre.contenu_repertoire.Focused=true then fenetre.effacer_fichier;
        end;
end;

//Contrle des paramtres en ligne  l'activation
procedure TMSA_Converter.FormActivate(Sender: TObject);
var
    booltemp:boolean;
    
begin
    if premiere_activation=true then
    begin
        booltemp:=fichierini.ReadBool('main', 'explorateur_ouvert', false);
        if (booltemp=true) and (fenetre_explorateur=nil) then fenetre_explorateur:=TExplorer.Create(Application);
        //Prise en compte de paramtres en ligne de commande
        if paramcount>0 then parametres_en_ligne;
        selecfichier.InitialDir:=rep_utilisateur;
        premiere_activation:=false;
    end;
end;

end.

